package podresolver

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/gideon/gideon/internal/sensors"
)

type Option func(*Resolver)

func WithUpstream(upstream string) Option {
	return func(r *Resolver) {
		r.httpc.SetBaseURL(upstream)
	}
}

func WithLogger(l log.Logger) Option {
	return func(r *Resolver) {
		r.log = l
	}
}

func WithMetrics(sensors sensors.Sensor) Option {
	return func(r *Resolver) {
		r.sensors = sensors
	}
}
