package podresolver

import (
	"encoding/base64"

	"a.yandex-team.ru/yt/go/yson"
)

//go:generate easyjson

var ZeroPod = PodInfo{}

const (
	PodKindUnknown PodKind = iota
	PodKindYp
	PodKindNanny
)

type PodKind uint8

type PodInfo struct {
	Kind           PodKind
	Container      string
	ID             string
	PodSetID       string
	NannyServiceID string
}

//easyjson:json
type LabelAttr struct {
	Key   string `json:"key"`
	Value string `json:"value"`
}

//easyjson:json
type ISSPod struct {
	ID                string `json:"id"`
	ContainerName     string `json:"container_name"`
	PodSetID          string `json:"pod_set_id"`
	DynamicAttributes struct {
		Labels struct {
			Attributes []LabelAttr `json:"attributes"`
		} `json:"labels"`
	} `json:"dynamic_attributes"`
}

//easyjson:json
type ISSPods struct {
	PodInfo []ISSPod `json:"pod_info"`
}

//easyjson:json
type ISSInstance struct {
	SlotID        string `json:"slot"`
	SlotContainer string `json:"slotContainer"`
	InstanceData  struct {
		DeployEngine   string `json:"properties/DEPLOY_ENGINE"`
		NannyServiceID string `json:"properties/NANNY_SERVICE_ID"`
	} `json:"instanceData"`
}

//easyjson:json
type ISSInstances []ISSInstance

func (v *ISSPod) NannyService() string {
	for _, attr := range v.DynamicAttributes.Labels.Attributes {
		switch attr.Key {
		case "deploy_engine":
			if attr.Value != ypLiteDeployEngine {
				return ""
			}
		case "nanny_service_id":
			rawSvc, err := base64.StdEncoding.DecodeString(attr.Value)
			if err != nil {
				return ""
			}

			var serviceID string
			if err := yson.Unmarshal(rawSvc, &serviceID); err != nil {
				return ""
			}
			return serviceID
		}
	}

	return ""
}
