package probe

import (
	"fmt"

	"gopkg.in/yaml.v2"
)

var (
	_ yaml.Marshaler   = (*CollectKind)(nil)
	_ yaml.Unmarshaler = (*CollectKind)(nil)
)

type CollectKind uint16

const (
	CollectKindNone CollectKind = 0
	CollectKindAny  CollectKind = 1
	CollectKindSlot CollectKind = 2
	CollectKindSSH  CollectKind = 3
)

func (fk CollectKind) MarshalYAML() (interface{}, error) {
	return fk.String(), nil
}

func (fk *CollectKind) UnmarshalYAML(unmarshal func(interface{}) error) error {
	var kind string
	if err := unmarshal(&kind); err != nil {
		return err
	}

	switch kind {
	case "any", "":
		*fk = CollectKindAny
	case "ssh":
		*fk = CollectKindSSH
	case "slot":
		*fk = CollectKindSlot
	default:
		return fmt.Errorf("unknown filter kind: %s", kind)
	}
	return nil
}

func (fk CollectKind) String() string {
	switch fk {
	case CollectKindNone:
		return "none"
	case CollectKindAny:
		return "any"
	case CollectKindSlot:
		return "slot"
	case CollectKindSSH:
		return "ssh"
	default:
		return "unknown"
	}
}
