package protoqueue

import (
	"time"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/gideon/gideon/internal/sensors"
)

type Option func(q *ProtoQueue)

func WithFlushInterval(interval time.Duration) Option {
	return func(q *ProtoQueue) {
		q.flushInterval = interval
	}
}

func WithWriteBufferSize(size int) Option {
	return func(q *ProtoQueue) {
		q.writeBufferSize = size
	}
}

func WithMaxSize(size int) Option {
	return func(q *ProtoQueue) {
		q.maxSize = size
	}
}

func WithLogger(l log.Logger) Option {
	return func(q *ProtoQueue) {
		q.log = l
	}
}

func WithMetrics(sensor sensors.Sensor) Option {
	return func(q *ProtoQueue) {
		q.sensors = sensor
	}
}

func WithCompression(enabled bool) Option {
	return func(q *ProtoQueue) {
		if enabled {
			q.compress = q.zstdCompression
		} else {
			q.compress = q.nopCompression
		}
	}
}
