package auto

import (
	"fmt"

	"a.yandex-team.ru/security/gideon/gideon/internal/secrets"
	"a.yandex-team.ru/security/gideon/gideon/internal/secrets/env"
	"a.yandex-team.ru/security/gideon/gideon/internal/secrets/file"
	"a.yandex-team.ru/security/gideon/gideon/internal/secrets/nuvault"
)

func NewProvider(cfg secrets.Config) (secrets.Provider, error) {
	newProvier := func() (secrets.Provider, error) {
		switch cfg.Kind {
		case secrets.ProviderKindEnv:
			return env.NewProvider(cfg)
		case secrets.ProviderKindFile:
			return file.NewProvider(cfg)
		case secrets.ProviderKindNuVault:
			return nuvault.NewProvider(cfg)
		default:
			return nil, fmt.Errorf("unknown secrets provider: %s", cfg.Kind)
		}
	}

	provider, err := newProvier()
	if err != nil {
		return nil, fmt.Errorf("failed to create secrets provider (%s): %w", cfg.Kind, err)
	}

	return provider, nil
}
