package env

import (
	"context"
	"fmt"
	"os"

	"a.yandex-team.ru/security/gideon/gideon/internal/secrets"
)

var _ secrets.Provider = (*Provider)(nil)

type Provider struct {
	cfg secrets.Config
}

func NewProvider(cfg secrets.Config) (*Provider, error) {
	return &Provider{
		cfg: cfg,
	}, nil
}

func (p *Provider) GetSecret(_ context.Context, key string) (string, error) {
	envKey, ok := p.cfg.Secrets[key]
	if !ok {
		envKey = key
	}

	out := os.Getenv(envKey)
	if out == "" {
		return "", fmt.Errorf("key %s (%s) was not found in env", envKey, key)
	}

	return out, nil
}

func (p *Provider) Close() error {
	return nil
}
