package secrets

import (
	"fmt"
)

const (
	ProviderKindUnknown ProviderKind = iota
	ProviderKindEnv
	ProviderKindFile
	ProviderKindNuVault

	ProviderKindUnknownName = "unknown"
	ProviderKindEnvName     = "env"
	ProviderKindFileName    = "file"
	ProviderKindNuVaultName = "nu-vault"
)

type ProviderKind uint8

func (k ProviderKind) MarshalYAML() (interface{}, error) {
	return k.String(), nil
}

func (k *ProviderKind) UnmarshalYAML(unmarshal func(interface{}) error) error {
	var kind string
	if err := unmarshal(&kind); err != nil {
		return err
	}

	switch kind {
	case ProviderKindEnvName:
		*k = ProviderKindEnv
	case ProviderKindFileName:
		*k = ProviderKindFile
	case ProviderKindNuVaultName:
		*k = ProviderKindNuVault
	default:
		return fmt.Errorf("unknown secrets provider: %s", kind)
	}
	return nil
}

func (k ProviderKind) String() string {
	switch k {
	case ProviderKindEnv:
		return ProviderKindEnvName
	case ProviderKindFile:
		return ProviderKindFileName
	case ProviderKindNuVault:
		return ProviderKindNuVaultName
	default:
		return ProviderKindUnknownName
	}
}
