package nuvault

import (
	"context"
	"fmt"

	"a.yandex-team.ru/security/gideon/gideon/internal/secrets"
	"a.yandex-team.ru/security/gideon/nuvault/pkg/nuvault"
	"a.yandex-team.ru/security/gideon/nuvault/pkg/nuvrpc"
)

var _ secrets.Provider = (*Provider)(nil)

type Provider struct {
	cfg     secrets.Config
	nuc     *nuvault.Client
	secrets map[string]*nuvrpc.Secret
}

func NewProvider(cfg secrets.Config) (*Provider, error) {
	nuc, err := nuvault.NewClient(nuvault.WithMutualAuth(cfg.CrtPath))
	if err != nil {
		return nil, err
	}

	return &Provider{
		cfg:     cfg,
		nuc:     nuc,
		secrets: make(map[string]*nuvrpc.Secret, len(cfg.Secrets)),
	}, nil
}

func (p *Provider) GetSecret(ctx context.Context, key string) (string, error) {
	yavKey, ok := p.cfg.Secrets[key]
	if !ok {
		return "", fmt.Errorf("key %s was not found", key)
	}

	if secret, ok := p.secrets[yavKey]; ok {
		return secret.Values[key], nil
	}

	secret, err := p.nuc.GetSecret(ctx, yavKey)
	if err != nil {
		return "", err
	}

	p.secrets[yavKey] = secret
	return secret.Values[key], nil
}

func (p *Provider) Close() error {
	return p.nuc.Close()
}
