package tracer

const (
	rawSyscallTailMapName       = "raw_syscall_tail"
	seccompSyscallTailMapName   = "seccomp_syscall_tail"
	settingsMapName             = "settings_map"
	eventMapName                = "events"
	bpfBufferSize               = 8 * 4096
	bpfLogSize                  = 10 * 1024 * 1024
	rawSyscallTracepointFmt     = "trace_sys_%s"
	seccompSyscallTracepointFmt = "kprobe_sys_%s"
	freezerCgroupPath           = "/sys/fs/cgroup/freezer"
	sessionIDFmt                = "/proc/%d/sessionid"
	portoRootPath               = "/porto/"
	slotContainerPrefix         = "/porto/ISS-AGENT-"
	sessionLeaderHeader         = "sessionleader: portoshell-session"
)

var (
	portoTracepoints = []string{
		"cgroup_mkdir",
		"cgroup_rmdir",
	}
)
