package tracer

import (
	"fmt"

	"github.com/cilium/ebpf"

	"a.yandex-team.ru/security/gideon/gideon/internal/cgroup"
)

//#include "gideon.h"
import "C"

func (t *Tracer) bpfSettings(orig *ebpf.MapSpec) (*ebpf.Map, error) {
	rootCgrpID, err := cgroup.GetCgroupID(freezerCgroupPath)
	if err != nil {
		return nil, fmt.Errorf("can't get freezer cgroup: %w", err)
	}

	settings := C.struct_bpf_settings_t{
		root_cgroup_id: C.ulonglong(rootCgrpID),
	}

	out, err := ebpf.NewMap(orig)
	if err != nil {
		return nil, fmt.Errorf("can't create new map: %w", err)
	}

	err = out.Put(uint32(0), settings)
	if err != nil {
		return nil, fmt.Errorf("can't initialize settings map: %w", err)
	}

	return out, nil
}
