package yasm

import (
	"time"

	"a.yandex-team.ru/library/go/core/log"
)

type Option func(pusher *Pusher)

func WithUpstream(upstream string) Option {
	return func(pusher *Pusher) {
		pusher.httpc.SetBaseURL(upstream)
	}
}

func WithLogger(l log.Logger) Option {
	return func(pusher *Pusher) {
		pusher.log = l
	}
}

func WithTimeout(timeout time.Duration) Option {
	return func(pusher *Pusher) {
		pusher.httpc.SetTimeout(timeout)
	}
}

func WithYasmTags(tags map[string]string) Option {
	return func(pusher *Pusher) {
		pusher.data[0].Tags = tags
	}
}

func WithYasmTTL(ttl time.Duration) Option {
	return func(pusher *Pusher) {
		pusher.data[0].TTL = uint32(ttl.Seconds())
	}
}
