package cfgvalid

import (
	"io/ioutil"

	"gopkg.in/yaml.v2"

	"a.yandex-team.ru/security/gideon/gideon/internal/config"
)

func ValidateConfig(cfgPath string) error {
	yamlCFG, err := ioutil.ReadFile(cfgPath)
	if err != nil {
		return err
	}

	var cfg config.Config
	return yaml.UnmarshalStrict(yamlCFG, &cfg)
}
