package commands

import (
	"context"
	"fmt"
	"time"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/gideon/nuvault/pkg/nuvault"
)

func init() {
	pingCmd.AddCommand(pingReadinessCmd)
	pingCmd.AddCommand(pingLivenessCmd)
	rootCmd.AddCommand(pingCmd)
}

var pingCmd = &cobra.Command{
	Use:   "ping",
	Short: "Ping nuvault",
}

var pingReadinessCmd = &cobra.Command{
	Use:   "readiness",
	Short: "check readiness",
	RunE: func(_ *cobra.Command, _ []string) error {
		client, err := nuvault.NewClient(
			nuvault.WithTimeout(100*time.Millisecond),
			nuvault.WithAddr(apiAddr),
			nuvault.WithNoAuth(),
		)

		if err != nil {
			return err
		}

		defer func() {
			_ = client.Close()
		}()

		if err = client.PingReadiness(context.Background()); err != nil {
			return err
		}

		fmt.Println("OK")
		return nil
	},
}

var pingLivenessCmd = &cobra.Command{
	Use:   "liveness",
	Short: "check liveness",
	RunE: func(_ *cobra.Command, _ []string) error {
		client, err := nuvault.NewClient(
			nuvault.WithTimeout(100*time.Millisecond),
			nuvault.WithAddr(apiAddr),
			nuvault.WithNoAuth(),
		)

		if err != nil {
			return err
		}

		defer func() {
			_ = client.Close()
		}()

		if err = client.PingLiveness(context.Background()); err != nil {
			return err
		}

		fmt.Println("OK")
		return nil
	},
}
