package commands

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/security/gideon/nuvault/pkg/nuvault"
)

var rootCmd = &cobra.Command{
	Use:          "nuvaultc",
	SilenceUsage: true,
	Short:        "NuVault client",
}

var (
	apiAddr string
	logger  = func() log.Logger {
		zlog, err := zap.New(zap.ConsoleConfig(log.InfoLevel))
		if err != nil {
			panic(fmt.Sprintf("failed to create logger: %s", err))
		}
		return zlog
	}()
)

func init() {
	flags := rootCmd.PersistentFlags()
	flags.StringVar(&apiAddr, "addr", nuvault.DefaultAddr, "custom NuVault API addr")
}

func Execute() {
	if err := rootCmd.Execute(); err != nil {
		os.Exit(1)
	}
}
