package app

import (
	"context"
	"fmt"
	"regexp"

	"google.golang.org/grpc/credentials"
	"google.golang.org/grpc/peer"
)

const rtcHosts = `^.*\.yandex\.net$`

var rtcHostsRE = regexp.MustCompile(rtcHosts)

func authenticate(ctx context.Context) (string, error) {
	peerInfo, ok := peer.FromContext(ctx)
	if !ok {
		return "", errNoPeerInfo
	}

	tlsInfo, ok := peerInfo.AuthInfo.(credentials.TLSInfo)
	if !ok {
		return "", errNoTLSPeerInfo
	}

	if len(tlsInfo.State.VerifiedChains) == 0 || len(tlsInfo.State.VerifiedChains[0]) == 0 {
		return "", errNoValidatedTLSInfo
	}

	cn := tlsInfo.State.VerifiedChains[0][0].Subject.CommonName
	if !rtcHostsRE.MatchString(cn) {
		return "", fmt.Errorf("CN '%s' doesn't match required '%s'", cn, rtcHosts)
	}

	return cn, nil
}
