package app

import (
	"context"

	"google.golang.org/protobuf/types/known/emptypb"

	"a.yandex-team.ru/security/gideon/nuvault/pkg/nuvrpc"
)

var pingRsp = &emptypb.Empty{}

func (a *App) Readiness(context.Context, *emptypb.Empty) (*emptypb.Empty, error) {
	if err := a.yavc.InSync(); err != nil {
		return nil, err
	}

	return pingRsp, nil
}

func (a *App) Liveness(context.Context, *emptypb.Empty) (*emptypb.Empty, error) {
	return pingRsp, nil
}

func (a *App) GetSecret(_ context.Context, req *nuvrpc.GetSecretRequest) (*nuvrpc.GetSecretResponse, error) {
	if req.SecretUuid == "" {
		return nil, errNoSecretUUID
	}

	secret, err := a.yavc.GetSecret(req.SecretUuid)
	if err != nil {
		return nil, err
	}

	return &nuvrpc.GetSecretResponse{
		Secret: secret,
	}, nil
}
