package config

import (
	"context"
	"os"
	"time"

	"github.com/heetch/confita"
	"github.com/heetch/confita/backend/file"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/gideon/nuvault/internal/yaver"
)

const (
	ShutdownDeadline = 10 * time.Second
)

type Config struct {
	LogLevel string       `yaml:"log_level"`
	API      API          `yaml:"http"`
	Yav      yaver.Config `yaml:"yav"`
}

type API struct {
	Addr     string `yaml:"addr"`
	SvrCrt   string `yaml:"srv_crt"`
	SvrKey   string `yaml:"srv_key"`
	ClientCa string `yaml:"client_ca"`
	HostsRE  string `yaml:"hosts_re"`
}

func NewConfig(configPath string) (*Config, error) {
	cfg := &Config{
		LogLevel: log.InfoString,
		API: API{
			Addr: ":3000",
		},
		Yav: yaver.Config{
			AuthToken:  os.Getenv("AUTH_TOKEN"),
			SyncPeriod: 30 * time.Minute,
			SyncDrift:  12 * time.Hour,
		},
	}

	loader := confita.NewLoader(file.NewBackend(configPath))
	if err := loader.Load(context.Background(), cfg); err != nil {
		return nil, err
	}

	return cfg, nil
}
