#pragma once

#include <util/generic/strbuf.h>
#include "ssh_utils.h"

namespace NGideon {

    struct TSessionInfo {
        ui32 GideonID = 0;
        TString UserName;
        TString SessionID;
        TString TTYName;
        NSsh::TAuthInfo AuthInfo;
    };

    const TString &KernelVersion();

    int CompareKernelVersion(const TStringBuf &version);

    bool CheckPrerequisites();

    ui32 CurrentGideonID();

    TString StartSession(const TSessionInfo *sessionInfo);
}
