#include "seccomp.h"

#include <util/generic/yexception.h>

#include <linux/seccomp.h>
#include <linux/audit.h>
#include <linux/filter.h>
#include <linux/unistd.h>
#include <sys/prctl.h>
#include <cerrno>

bool NGideon::NSeccomp::SetupSeccomp() {
    int ret;

    struct sock_filter filter[] = {
            /* validate arch */
            BPF_STMT(BPF_LD + BPF_W + BPF_ABS, (offsetof(struct seccomp_data, arch))),
            BPF_JUMP(BPF_JMP + BPF_JEQ + BPF_K, AUDIT_ARCH_X86_64, 1, 0),
            BPF_STMT(BPF_RET + BPF_K, SECCOMP_RET_ERRNO | (EPERM & SECCOMP_RET_DATA)),

            /* that's fine, we log syscalls in the eBPF program */
            BPF_STMT(BPF_RET + BPF_K, SECCOMP_RET_ALLOW),
    };

    struct sock_fprog prog = {
            .len = (unsigned short) (sizeof(filter) / sizeof(filter[0])),
            .filter = filter,
    };

    ret = prctl(PR_SET_SECCOMP, SECCOMP_MODE_FILTER, &prog);
    if (ret != 0) {
        ythrow TSystemError(ret) << "prctl(PR_SET_SECCOMP, SECCOMP_MODE_FILTER, ...) failed";
    }

    return true;
}
