#pragma once

#include <util/generic/strbuf.h>
#include <util/generic/string.h>
#include <util/generic/yexception.h>

namespace NGideon::NSsh {
    struct TParseError : yexception {
    };

    enum class EAuthMethod {
        Undef,
        PublicKey,
        Password,
    };

    struct TAuthInfo {
        EAuthMethod AuthMethod = EAuthMethod::Undef;
        TString KeyTypeName;
        TString Fingerprint;

        [[nodiscard]] TString Description() const;

        bool operator==(const TAuthInfo& other) const {
            return (
                    this->AuthMethod == other.AuthMethod &&
                    this->KeyTypeName == other.KeyTypeName &&
                    this->Fingerprint == other.Fingerprint
            );
        }
    };

    [[nodiscard]] inline TString AuthMethodName(EAuthMethod method) {
        switch (method) {
            case EAuthMethod::PublicKey:
                return "publickey";
            case EAuthMethod::Password:
                return "password";
            default:
                return "n/a";
        }
    }

    TAuthInfo ParseAuthInfo(TStringBuf data);
}
