package main

import (
	"os"
	"os/signal"
	"syscall"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/library/go/test/yatest"
)

func main() {
	zapCFG := zap.ConsoleConfig(log.DebugLevel)
	zapCFG.OutputPaths = []string{
		yatest.OutputPath("fake-gideon.log"),
	}

	l, err := zap.New(zapCFG)
	if err != nil {
		panic(err)
	}

	closer, err := newServer(l)
	if err != nil {
		panic(err)
	}

	stopChan := make(chan os.Signal, 1)
	signal.Notify(stopChan, syscall.SIGINT)

	<-stopChan
	closer()
}
