package db

// TODO(buglloc): rename table
const createTablesQ = `
CREATE TABLE IF NOT EXISTS gevents ON CLUSTER '{cluster}' (
	TS UInt64,
	Source String,
	Host String,
	Kind Int32,

-- proc info
	Proc_Pid UInt32,
	Proc_Name String,
	Proc_Ppid UInt32,
	Proc_ParentName String,
	Proc_Uid UInt32,
	Proc_SessionID UInt32,
	Proc_Container String,
	Proc_PodID String,
	Proc_PodSetID String,
	Proc_NannyID String,

-- ProcExec event
	ProcExec_Exe String,
	ProcExec_Args Array(String),

-- Ptrace event
	Ptrace_RetCode Int64,
	Ptrace_Request Int64,
	Ptrace_Target Int32,

-- Connect event
	Connect_Family Int32,
	Connect_SrcAddr String,
	Connect_SrcPort UInt32,
	Connect_DstAddr String,
	Connect_DstPort UInt32,

-- ExecveAt event
	ExecveAt_RetCode Int64,
	ExecveAt_FD Int64,
	ExecveAt_Filename String,
	ExecveAt_Args Array(String),

-- SSHSession event
	SSHSession_ID String,
	SSHSession_User String,
	SSHSession_TTY String,
	SSHSession_Kind Int32,

-- OpenAt event
	OpenAt_RetCode Int64,
	OpenAt_FD Int64,
	OpenAt_Filename String,
	OpenAt_Flags Int32

) ENGINE = ReplicatedReplacingMergeTree('/clickhouse/tables/{shard}/gevents', '{replica}')
PARTITION BY toYYYYMMDD(toDateTime(TS/1000000000))
ORDER BY TS;
`

const insertProcExecQ = `INSERT INTO gevents (
	TS,
	Source,
	Host,
	Kind,
	Proc_Pid,
	Proc_Name,
	Proc_Ppid,
	Proc_ParentName,
	Proc_Uid,
	Proc_SessionID,
	Proc_Container,
	Proc_PodID,
	Proc_PodSetID,
	Proc_NannyID,
	ProcExec_Exe,
	ProcExec_Args
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`

const insertPtraceQ = `INSERT INTO gevents (
	TS,
	Source,
	Host,
	Kind,
	Proc_Pid,
	Proc_Name,
	Proc_Ppid,
	Proc_ParentName,
	Proc_Uid,
	Proc_SessionID,
	Proc_Container,
	Proc_PodID,
	Proc_PodSetID,
	Proc_NannyID,
	Ptrace_RetCode,
	Ptrace_Request,
	Ptrace_Target
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`

const insertConnectQ = `INSERT INTO gevents (
	TS,
	Source,
	Host,
	Kind,
	Proc_Pid,
	Proc_Name,
	Proc_Ppid,
	Proc_ParentName,
	Proc_Uid,
	Proc_SessionID,
	Proc_Container,
	Proc_PodID,
	Proc_PodSetID,
	Proc_NannyID,
	Connect_Family,
	Connect_SrcAddr,
	Connect_SrcPort,
	Connect_DstAddr,
	Connect_DstPort
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`

const insertExecveAtQ = `INSERT INTO gevents (
	TS,
	Source,
	Host,
	Kind,
	Proc_Pid,
	Proc_Name,
	Proc_Ppid,
	Proc_ParentName,
	Proc_Uid,
	Proc_SessionID,
	Proc_Container,
	Proc_PodID,
	Proc_PodSetID,
	Proc_NannyID,
	ExecveAt_RetCode,
	ExecveAt_FD,
	ExecveAt_Filename,
	ExecveAt_Args
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`

const insertOpenAtQ = `INSERT INTO gevents (
	TS,
	Source,
	Host,
	Kind,
	Proc_Pid,
	Proc_Name,
	Proc_Ppid,
	Proc_ParentName,
	Proc_Uid,
	Proc_SessionID,
	Proc_Container,
	Proc_PodID,
	Proc_PodSetID,
	Proc_NannyID,
	OpenAt_RetCode,
	OpenAt_FD,
	OpenAt_Filename,
	OpenAt_Flags
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`

const insertSSHSessionQ = `INSERT INTO gevents (
	TS,
	Source,
	Host,
	Kind,
	Proc_Pid,
	Proc_Name,
	Proc_Ppid,
	Proc_ParentName,
	Proc_Uid,
	Proc_SessionID,
	Proc_Container,
	Proc_PodID,
	Proc_PodSetID,
	Proc_NannyID,
	SSHSession_ID,
	SSHSession_User,
	SSHSession_TTY,
	SSHSession_Kind
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`

const listPartitionsQF = `SELECT partition FROM system.parts WHERE database = '%s' AND table = 'gevents' GROUP BY partition`

const dropPartitionsQF = `ALTER TABLE gevents ON CLUSTER '{cluster}' DROP PARTITION %d`
