package lbmask

import (
	"encoding/binary"

	"a.yandex-team.ru/security/gideon/speedy-beaver/internal/events"
)

var (
	protoMagic = []byte{
		0x1F, 0xF7, 0xF7, 0x7E, 0xBE, 0xA6, 0x5E, 0x9E, 0x37, 0xA6, 0xF6, 0x2E, 0xFE, 0xAE, 0x47, 0xA7, 0xB7, 0x6E,
		0xBF, 0xAF, 0x16, 0x9E, 0x9F, 0x37, 0xF6, 0x57, 0xF7, 0x66, 0xA7, 0x06, 0xAF, 0xF7,
	}

	protoMetaLen = uint32(4 + len(protoMagic))
)

type batchBuffer struct {
	buf      []byte
	length   uint32
	capacity uint32
}

func newBatchBuffer(capacity uint32) batchBuffer {
	return batchBuffer{
		buf:      make([]byte, capacity),
		length:   0,
		capacity: capacity,
	}
}

func (b *batchBuffer) canPush(size uint32) bool {
	return b.length+size+protoMetaLen <= b.capacity
}

func (b *batchBuffer) push(size uint32, event *events.Event) error {
	buf := b.buf[b.length:]
	binary.LittleEndian.PutUint32(buf, size)
	_, err := event.MarshalTo(buf[4:])
	if err != nil {
		return err
	}
	copy(buf[4+size:], protoMagic)
	b.length += protoMetaLen + size
	return nil
}

func (b *batchBuffer) getBuf() []byte {
	return b.buf[:b.length]
}

func (b *batchBuffer) clear() {
	b.buf = make([]byte, b.capacity)
	b.length = 0
}
