package lbmask

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/gideon/speedy-beaver/internal/unistat"
)

type (
	Option interface {
		isOption()
	}

	LoggerOption struct {
		Option
		Logger log.Logger
	}

	SensorOption struct {
		Option
		Unistat *unistat.Sensor
	}
)

func WithLogger(l log.Logger) Option {
	return LoggerOption{
		Logger: l,
	}
}

func WithUnistat(sensor *unistat.Sensor) Option {
	return SensorOption{
		Unistat: sensor,
	}
}
