package unistat

import (
	"sync/atomic"
)

/*
* documentation for stats semantic: https://wiki.yandex-team.ru/golovan/stat-handle/#defoltnyesigopt-suffiksy
 */
type Sensor struct {
	lbRestarts  int64
	batches     int64
	chErrors    int64
	chBatches   int64
	maskError   int64
	maskBatches int64
	events      int64
	writes      int64
}

func (s *Sensor) LbRestarts(n int64) {
	atomic.AddInt64(&s.lbRestarts, n)
}

func (s *Sensor) Batch(n int64) {
	atomic.AddInt64(&s.batches, n)
}

func (s *Sensor) ChError(n int64) {
	atomic.AddInt64(&s.chErrors, n)
}

func (s *Sensor) ChBatch(n int64) {
	atomic.AddInt64(&s.chBatches, n)
}

func (s *Sensor) MaskError(n int64) {
	atomic.AddInt64(&s.maskError, n)
}

func (s *Sensor) MaskBatch(n int64) {
	atomic.AddInt64(&s.maskBatches, n)
}

func (s *Sensor) Event(n int64) {
	atomic.AddInt64(&s.events, n)
}

func (s *Sensor) Write(n int64) {
	atomic.AddInt64(&s.writes, n)
}

func (s *Sensor) FlushPull() [][]interface{} {
	return [][]interface{}{
		{"batches_summ", atomic.SwapInt64(&s.batches, 0)},
		{"ch-errors_summ", atomic.SwapInt64(&s.chErrors, 0)},
		{"ch-batches_summ", atomic.SwapInt64(&s.chBatches, 0)},
		{"mask-errors_summ", atomic.SwapInt64(&s.maskError, 0)},
		{"mask-batches_summ", atomic.SwapInt64(&s.maskBatches, 0)},
		{"events_summ", atomic.SwapInt64(&s.events, 0)},
		{"writes_summ", atomic.SwapInt64(&s.writes, 0)},
		{"lb-restarts_summ", atomic.SwapInt64(&s.lbRestarts, 0)},
	}
}
