#include "execve.h"

#include <sys/syscall.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <cstdlib>
#include <unistd.h>
#include <util/generic/yexception.h>
#include <vector>


namespace NGideonStress {
    namespace {
        char *envp[] = { nullptr, nullptr, nullptr };

    }  // anonymous

    int testExecve(int count, int size) {
        TString payload(size, 'A');
        std::vector<const char *> argv = {
                "execve",
                payload.data(),
                nullptr
        };

        int status;
        pid_t child = vfork();
        if (child < 0) {
            ythrow TSystemError() << "vfork() failed";
        }

        if (child == 0) {
            for (int i = 0; i < count; ++i) {
                syscall(__NR_execve, "/non-existent", argv.data(), envp);
            }
            _exit(0);
        }
        waitpid(child, &status, 0);
        return count;
    }
}
