#include "execve_at.h"

#include <sys/syscall.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <cstdlib>
#include <unistd.h>
#include <util/generic/yexception.h>
#include <vector>


namespace NGideonStress {
    namespace {
        char *envp[] = { nullptr, nullptr, nullptr };

        int mustOpen(const char *filename, int flags) {
            int fd = open(filename, flags);

            if (fd < 0) {
                ythrow TSystemError() << "Failed to open '" << filename << "'";
            }
            return fd;
        }

    }  // anonymous

    int testExecveAt(int count, int size) {
        TString payload(size, 'A');
        std::vector<const char *> argv = {
                "execveat",
                payload.data(),
                nullptr
        };

        int status;
        int fd = mustOpen(".", O_DIRECTORY|O_RDONLY);
        pid_t child = vfork();
        if (child < 0) {
            ythrow TSystemError() << "vfork() failed";
        }

        if (child == 0) {
            for (int i = 0; i < count; ++i) {
                syscall(__NR_execveat, fd, "non-existent", argv.data(), envp, 0);
            }
            _exit(0);
        }
        waitpid(child, &status, 0);
        return count;
    }
}
