#include "options.h"

#include "execve.h"
#include "execve_at.h"
#include "proc_exec.h"
#include "getppid.h"

#include <security/libs/cpp/log/log.h>
#include <util/system/datetime.h>


using namespace NGideonStress;

namespace {
    class TTimer {
    public:
        TTimer()
        : StartTime(TInstant::Now()){};

        [[nodiscard]] TDuration Elapsed() const {
            return TInstant::Now() - StartTime;
        }

    private:
        TInstant StartTime;
    };
}  // anonymous

int main(int argc, char** argv) {

    try {
        auto opts = TProgramOptions::Parse(argc, argv);
        TTimer timer;

        switch (opts.TestKind) {
            case ETestKind::Execve:
                testExecve(opts.Count, opts.PayloadSize);
                break;
            case ETestKind::ExecveAt:
                testExecveAt(opts.Count, opts.PayloadSize);
                break;
            case ETestKind::ProcExec:
                testProcExec(opts.Count, opts.PayloadSize);
                break;
            case ETestKind::Getppid:
                testGetppid(opts.Count, opts.PayloadSize);
                break;
            default:
                ythrow TSystemError() << "unexpected event kind: " << opts.TestKind;
        }

        Cout << "Finished " << opts.Count << " passes of '" << opts.TestKind <<"' in " << timer.Elapsed() << Endl;
    } catch (const yexception& e) {
        NSecurityHelpers::LogErr("Test failed", "err", e.AsStrBuf());
        return 1;
    }
    return 0;
}
