#include "options.h"

#include <util/string/cast.h>
#include <util/generic/serialized_enum.h>
#include <library/cpp/getopt/last_getopt.h>


namespace NGideonStress {

const TProgramOptions TProgramOptions::Parse(int argc, char** argv) {
    auto options = TProgramOptions();

    using namespace NLastGetopt;
    TOpts opts = TOpts::Default();

    opts.SetTitle("Gideon stress test");

    opts.AddLongOption("count", "passes count")
        .DefaultValue(10)
        .StoreResult(&options.Count);

    opts.AddLongOption("payload-size", "minimal payload size")
            .DefaultValue(1)
            .StoreResult(&options.PayloadSize);

    opts.AddLongOption("type", "test type: " + GetEnumAllNames<ETestKind>())
        .DefaultValue(ToString(ETestKind::Execve));

    TOptsParseResult args(&opts, argc, argv);

    options.TestKind = FromString<ETestKind>(args.Get("type"));
    return options;
}

}  // namespace NGideonStress
