#pragma once

#include <sys/inotify.h>
#include <util/generic/string.h>
#include <util/datetime/base.h>

namespace NGideonStress {

enum ETestKind : ui32 {
    // execve syscall
    Execve /* "execve" */,

    // execveat syscall
    ExecveAt /* "execveat" */,

    // real process execution
    ProcExec /* "proc_exec" */,

    // getppid syscall
    Getppid /* "getppid" */,
};


class TProgramOptions {
public:
    int Count;
    int PayloadSize;
    ETestKind TestKind;

    static const TProgramOptions Parse(int argc, char** argv);

};

}  // namespace NGideonStress
