#include "execve.h"

#include <sys/syscall.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <cstdlib>
#include <unistd.h>
#include <util/generic/yexception.h>
#include <vector>


namespace NGideonStress {
    namespace {
        const char *script_path = "/bin/false";
        char *envp[] = { nullptr, nullptr, nullptr };

        void runProc(const char *path, std::vector<const char *> argv ) {
            int status;
            pid_t child = vfork();
            if (child < 0) {
                ythrow TSystemError() << "vfork() failed";
            }

            if (child == 0) {
                syscall(__NR_execve, path, argv.data(), envp);
                _exit(0);
            }
            waitpid(child, &status, 0);
        }
    }  // anonymous

    int testProcExec(int count, int size) {
        TString payload(size, 'A');
        std::vector<const char *> argv = {
                "false",
                payload.data(),
                nullptr
        };

        for (int i = 0; i < count; ++i) {
            runProc(script_path, argv);
        }

        return count;
    }
}
