import React from "react";
import {SwitchRoutes} from "../../components/lib";

import {User} from "../../models";
import {ROUTES} from "../../pages/_routes";

import {AppShell} from "../AppShell/AppShell";

import {Observable} from "rxjs";

interface Props {
    user: User;
    newVersion: Observable<boolean>;
}

export const App: React.FC<Props> = ({user, newVersion}) => {
    const [newVersionAvailable, setNewVersionAvailable] = React.useState(false);

    React.useEffect(() => {
        const onNewVersion = newVersion.subscribe((value) => {
            setNewVersionAvailable(value);
        });
        return () => {
            onNewVersion.unsubscribe();
        };
    }, [newVersion]);

    return (
        <AppShell user={user} newVersionAvailable={newVersionAvailable}>
            <SwitchRoutes>{ROUTES}</SwitchRoutes>
        </AppShell>
    );
};

App.displayName = "App";
