import {classNames, ModalContainer, ToastContainer} from "@yandex-infracloud-ui/libs";
import {Pointerfocus} from "lego-on-react";
import React from "react";

import {User} from "../../models";
import {FooterWrap} from "../FooterWrap/FooterWrap";
import Header from "../Header/Header";
import {Banner} from "../../components";

import classes from "./AppShell.module.css";

interface Props {
    isLanding?: boolean;
    stickyHeader?: boolean;
    newVersionAvailable?: boolean;
    user: User;
}

export const AppShell: React.FC<Props> = ({stickyHeader = true, newVersionAvailable = false, user, children}) => (
    <div>
        {newVersionAvailable && (
            <Banner
                title={"New version available!"}
                description={"The new version of the web application is ready to use"}
                action={"Reload the page"}
                onAction={() => window.location.reload()}
            />
        )}
        <header className={classNames(classes.header, {[classes.sticky]: stickyHeader})}>
            <Header user={user} />
        </header>
        <main className={classes.content}>{children}</main>
        <FooterWrap />
        <Pointerfocus />
        <ModalContainer />
        <ToastContainer />
    </div>
);

AppShell.displayName = "AppShell";
