import block from "bem-cn-lite";
import {User} from "lego-on-react";
import PropTypes from "prop-types";
import React from "react";

import NavigationTabs from "../../old-code/components/NavigationTabs/NavigationTabs";
import RouteLink from "../../old-code/components/RouteLink/RouteLink";
import {Logo} from "../Logo/Logo";

import "./Header.scss";

const b = block("header");

// TODO port to TS/hooks
export default class Header extends React.Component {
    static propTypes = {
        user: PropTypes.object,
    };

    renderLogo() {
        return (
            <div className={b("logo")} data-test="logo">
                <RouteLink to={"/"} theme="normal" mix={{block: b("logo-link")}}>
                    <Logo />
                </RouteLink>
            </div>
        );
    }

    renderUser() {
        const {user} = this.props;

        return (
            <div className={b("user")}>
                <User
                    uid={user.uid}
                    yu={user.yandexuid}
                    name={user.displayName || user.login}
                    avatarId={user.login}
                    avatarHost={user.avatarHost}
                    passportHost={user.passportHost}
                    mods={{provider: "yandex-team", "fetch-accounts": "yes"}}
                    provider={"yandex-team"}
                    mix={{block: b("header-user")}}
                />
            </div>
        );
    }

    renderLinks() {
        return (
            <div className={b("links")} data-test="support-links">
                <a
                    className={b("link")}
                    href="https://wiki.yandex-team.ru/security/gideon/"
                    target="_blank"
                    rel="noopener noreferrer"
                    data-test="support-link-wiki"
                >
                    <span className={b("link-title")}>Wiki</span>
                    <i className={`far fa-external-link-square-alt ${b("link-icon")}`} />
                </a>
                <a
                    className={b("link")}
                    href="https://st.yandex-team.ru/gideon/"
                    target="_blank"
                    rel="noopener noreferrer"
                    data-test="support-link-st"
                >
                    <span className={b("link-title")}>ST</span>
                    <i className={`far fa-external-link-square-alt ${b("link-icon")}`} />
                </a>
            </div>
        );
    }

    renderTabs() {
        const tabs = [
            {
                path: "/",
                id: "events",
                title: "Events",
            },
            {
                path: "/monitoring",
                id: "monitoring",
                title: "Monitoring",
            },
        ];
        return <NavigationTabs tabs={tabs} className={b("tabs")} />;
    }

    render() {
        return (
            <div className={b()}>
                {this.renderLogo()}
                {this.renderTabs()}
                {this.renderLinks()}
                {this.renderUser()}
            </div>
        );
    }
}
