import {QueryInput} from "@yandex-infracloud-ui/query-input";
import React from "react";
import {fixedMemo} from "@yandex-infracloud-ui/libs";

import {EventsProvider} from "./provider/EventsProvider";

import lang from "../languages/KeyValueLanguage";
import theme from "../themes/KeyValueTheme";

interface EventsQueryInputProps {
    onChange?: (value?: string) => void;
    query: string;
    provider?: EventsProvider;
}

export const EventsQueryInput = fixedMemo((props: EventsQueryInputProps) => {
    return (
        <QueryInput
            query={props.query}
            onChange={props.onChange}
            rows={2}
            provider={props.provider}
            lang={lang}
            theme={theme}
            placeholder={"Example: kind=ProcExec"}
        />
    );
});
