import {VisitorConstructor} from "./QueryParser";

import {ExpressionNode, OperatorNode, QueryNode, ValueNode, ValuesNode} from "./nodes";

export class QueryInterpreter extends VisitorConstructor {
    constructor() {
        super();
        this.validateVisitor();
    }

    public query(ctx: QueryNode) {
        if (!ctx.expression) {
            return {};
        }

        return ctx.expression.reduce((acc, item) => {
            const {key, values, selectType} = this.visit(item);
            return {
                ...acc,
                [key]: {values, selectType},
            };
        }, {});
    }

    protected expression(ctx: ExpressionNode) {
        let key = ctx.Value[0].image;

        return {key, values: this.visit(ctx.values), selectType: this.visit(ctx.operator)};
    }

    protected values(ctx: ValuesNode) {
        if (!ctx.value) {
            return [];
        }

        return ctx.value.map((value) => this.visit(value));
    }

    protected value(ctx: ValueNode) {
        if (ctx.QuotedValue) {
            return ctx.QuotedValue[0].image.slice(1, -1); // remove quotes
        }

        return ctx.Value![0].image;
    }

    protected operator(ctx: OperatorNode) {
        if (ctx.Equal) {
            return "EQ";
        }

        if (ctx.NotEqual) {
            return "NE";
        }

        if (ctx.GreaterThan) {
            return "GT";
        }

        if (ctx.LessThan) {
            return "LT";
        }

        return "UNKNOWN";
    }
}
