import {Position} from "@yandex-infracloud-ui/query-input";
import {CstParser} from "chevrotain";

import matchLocation from "./matchLocation";
import tokens, {GreaterThan, LessThan} from "./tokens";
import {Comma, Equal, ExpressionSeparator, NotEqual, QuotedValue, Value} from "./tokens";

export class QueryParser extends CstParser {
    public query = this.RULE("query", () => {
        this.MANY(() => {
            this.SUBRULE(this.expression);
        });
    });

    public getToken(position: Position) {
        return this.input.find((token) => matchLocation(token, position));
    }

    private operator = this.RULE("operator", () => {
        this.OR([
            {ALT: () => this.CONSUME(Equal)},
            {ALT: () => this.CONSUME(NotEqual)},
            {ALT: () => this.CONSUME(GreaterThan)},
            {ALT: () => this.CONSUME(LessThan)},
        ]);
    });

    private value = this.RULE("value", () => {
        this.OR([{ALT: () => this.CONSUME(Value)}, {ALT: () => this.CONSUME(QuotedValue)}]);
    });

    // trailing comma support
    private values = this.RULE("values", () => {
        this.OPTION(() => {
            this.SUBRULE(this.value);
        });
        this.MANY(() => {
            this.CONSUME(Comma);
            this.SUBRULE2(this.value);
        });
        this.MANY2(() => {
            this.CONSUME2(Comma);
        });
    });

    private expression = this.RULE("expression", () => {
        this.CONSUME(Value);
        this.SUBRULE(this.operator);
        this.SUBRULE(this.values);
        this.OPTION(() => {
            // this.SUBRULE(this.expression);
            this.CONSUME(ExpressionSeparator);
        });
    });

    constructor() {
        super(tokens, {
            nodeLocationTracking: "full",
        });
        this.performSelfAnalysis();
    }
}

export const queryParser = new QueryParser();
export const VisitorConstructor = queryParser.getBaseCstVisitorConstructor();
