import {QueryInterpreter} from "./QueryInterpreter";

import {QueryNode} from "./nodes";

interface ValueList {
    values: string[];
    selectType: "EQ" | "NE" | "GT" | "LT";
}

interface UserField {
    path: string;
    values: string[];
    selectType: "EQ" | "NE" | "GT" | "LT";
}

export class RequestInterpreter extends QueryInterpreter {
    public query(ctx: QueryNode) {
        if (!ctx.expression) {
            return {};
        }

        const {fields, userFields} = ctx.expression.reduce(
            (acc, item) => {
                const {fields, userFields} = acc;
                const {key, values, selectType} = this.visit(item);

                return {
                    fields: {...fields, [key + "_list"]: {values, selectType}},
                    userFields,
                };
            },
            {fields: {} as {[key: string]: ValueList}, userFields: [] as UserField[]}
        );

        return {
            ...fields,
            userFieldList: userFields,
        };
    }
}
