import {Position} from "@yandex-infracloud-ui/query-input";

interface Location {
    startLine?: number;
    startColumn?: number;
    endLine?: number;
    endColumn?: number;
}

export default (location: Location, position: Position) => {
    const isMatch =
        location.startLine! >= position.lineNumber &&
        location.endLine! <= position.lineNumber &&
        location.startColumn! <= position.column &&
        location.endColumn! + 1 >= position.column;

    return isMatch;
};
