import {CstNode, IToken} from "chevrotain";

export type QueryNode = CstNode & {
    expression?: CstNode[];
};

export type ExpressionNode = CstNode & {
    Value: IToken[];
    values: CstNode;
    operator: CstNode;
    ExpressionSeparator?: IToken[];
};

export type OperatorNode = CstNode & {
    Equal?: IToken[];
    NotEqual?: IToken[];
    GreaterThan?: IToken[];
    LessThan?: IToken[];
};

export type ValuesNode = CstNode & {
    value?: CstNode[];
    Comma?: IToken[];
};

export type ValueNode = CstNode & {
    QuotedValue?: IToken[];
    Value?: IToken[];
};
