import {createToken, Lexer} from "chevrotain";

export const Value = createToken({name: "Value", pattern: /[^,\n\r";\s!=<>]+/});
export const QuotedValue = createToken({
    name: "QuotedValue",
    pattern: /"[^"]*"/,
});
export const Equal = createToken({name: "Equal", pattern: /=/});
export const NotEqual = createToken({name: "NotEqual", pattern: /!=/});
export const GreaterThan = createToken({name: "GreaterThan", pattern: />=/});
export const LessThan = createToken({name: "LessThan", pattern: /<=/});
export const Comma = createToken({name: "Comma", pattern: /,/});
export const ExpressionSeparator = createToken({
    name: "ExpressionSeparator",
    pattern: /;/,
});
export const WhiteSpace = createToken({
    group: Lexer.SKIPPED,
    name: "WhiteSpace",
    pattern: /\s+/,
});

export default [Comma, Equal, NotEqual, GreaterThan, LessThan, ExpressionSeparator, Value, QuotedValue, WhiteSpace];
