import {languages} from "monaco-editor/esm/vs/editor/editor.api";

import {AbstractLanguage} from "@yandex-infracloud-ui/query-input";

export class KeyValueLanguage extends AbstractLanguage {
    public static conf: languages.LanguageConfiguration = {
        autoClosingPairs: [{open: '"', close: '"'}],
        surroundingPairs: [{open: '"', close: '"'}],
    };

    public static language = {
        defaultToken: "",

        tokenizer: {
            root: [
                // keys
                [/(^[\w.]+)(\s*)([!<>~]*=)/, ["key", "", "operator"]],

                // whitespace
                {include: "@whitespace"},
            ],

            whitespace: [[/\s+/, ""]],
        },
    } as languages.IMonarchLanguage;

    constructor() {
        super("gideon-key-value", KeyValueLanguage.language, KeyValueLanguage.conf);
    }
}

export default new KeyValueLanguage();
