import {faBell, faCheck, faExclamationTriangle, IconDefinition} from "@fortawesome/free-solid-svg-icons";
import {FontAwesomeIcon} from "@fortawesome/react-fontawesome";
import {classNames} from "@yandex-infracloud-ui/libs";
import React from "react";

import classes from "./Badge.module.css";

export enum BadgeType {
    Success = "success",
    Warning = "warning",
    Error = "error",
}

const icons = new Map([
    [BadgeType.Success, faCheck],
    [BadgeType.Warning, faBell],
    [BadgeType.Error, faExclamationTriangle],
]);

interface Props {
    className?: string;
    icon?: IconDefinition | null;
    type: BadgeType;
}

export const Badge: React.FC<Props> = ({className, icon, type, children}) => (
    <span
        className={classNames(classes.badge, className, classes[type], {
            [classes.noIcon]: icon === null,
        })}
    >
        {icon === null ? null : <FontAwesomeIcon icon={icon ?? icons.get(type)!} className={classes.icon} />}

        {children}
    </span>
);

Badge.displayName = "Badge";
