import React from "react";

import {LegoButton} from "@yandex-infracloud-ui/libs";
import classes from "./Banner.module.css";

interface Props {
    title: string;
    description: string;
    action: string;
    onAction: () => void;
}

export const Banner: React.FC<Props> = ({title, description, action, onAction}) => {
    return (
        <div className={classes.banner}>
            <div className={classes.banner__info}>
                <h1>{title}</h1>
                <p>{description}</p>
            </div>
            <LegoButton theme={"normal"} tone={"default"} view={"default"} onClick={onAction}>
                {action}
            </LegoButton>
        </div>
    );
};
