import {classNames} from "@yandex-infracloud-ui/libs";
import {ButtonSize, ButtonTheme} from "lego-on-react";
import React from "react";
import {Link} from "react-router-dom";

import classes from "./ButtonLink.module.css";

interface Props {
    className?: string;
    size?: ButtonSize;
    theme?: ButtonTheme;
    to: string;
}

export const ButtonLink: React.FC<Props> = React.memo(({children, className, theme = "normal", size = "s", to}) => {
    return (
        <Link
            className={classNames(
                "control button2 button2_view_default button2_tone_default",
                `button2_size_${size}`,
                `button2_theme_${theme}`,
                classes.button,
                className
            )}
            to={to}
        >
            <span className="button2__text">{children}</span>
        </Link>
    );
});

ButtonLink.displayName = "ButtonLink";
