import {classNames, CopyableText} from "@yandex-infracloud-ui/libs";
import React from "react";

import classes from "./CopyableTextHovered.module.css";

interface Props {
    className?: string;
    text: string;
}

export const CopyableTextHovered: React.FC<Props> = ({className, text, children}) => (
    <span className={classNames(classes.wrapper, className)}>
        {children} <CopyableText text={text} className={classes.icon} />
    </span>
);

CopyableTextHovered.displayName = "CopyableTextHovered";
