import {classNames, fixedMemo, styleHelpers} from "@yandex-infracloud-ui/libs";
import React, {AnchorHTMLAttributes} from "react";

export const ExternalLink: React.FC<AnchorHTMLAttributes<any>> = fixedMemo(({className, children, ...rest}) => {
    return (
        // eslint-disable-next-line jsx-a11y/anchor-is-valid
        <a
            className={classNames(className, styleHelpers.externalLink)}
            target={"_blank"}
            rel={"noopener noreferrer"}
            {...rest}
        >
            {children}
        </a>
    );
});

ExternalLink.displayName = "ExternalLink";
