import * as React from "react";
import ReactJsonSyntaxHighlighter from "react-json-syntax-highlighter";

import styles from "./Json.module.css";

(ReactJsonSyntaxHighlighter as any).displayName = "ReactJsonSyntaxHighlighter";

function SimpleJson({value, type}: {value: any; type: string}) {
    return (
        <div className={"ReactJsonSyntaxHighlighter"}>
            <pre>
                <span className={type}>{JSON.stringify(value)}</span>
            </pre>
        </div>
    );
}

export const Json = React.memo(({obj}: {obj: any}) => {
    // Почему-то в библиотеке не поддерживаются примитивы
    if (obj === null || obj === undefined || Object.keys(obj).length === 0) {
        switch (typeof obj) {
            case "undefined":
                return <SimpleJson value={null} type={"null"} />;
            case "string":
                return <SimpleJson value={obj} type={"string"} />;
            case "number":
                return <SimpleJson value={obj} type={"number"} />;
            default:
                return <SimpleJson value={obj} type={"null"} />;
        }
    }

    return <ReactJsonSyntaxHighlighter obj={obj || {}} cls={styles.json} />;
});

Json.displayName = "Json";
