import {IconDefinition} from "@fortawesome/fontawesome-svg-core";
import {FontAwesomeIcon} from "@fortawesome/react-fontawesome";
import {classNames} from "@yandex-infracloud-ui/libs";
import {Button} from "lego-on-react";
import * as React from "react";

import classes from "./RowButtons.module.css";

export interface IButtonConfig {
    className?: string;
    icon?: IconDefinition;
    name: string;

    handler(): void;
}

interface Props {
    buttons: IButtonConfig[];
    className?: string;
    disabled?: boolean;
    showNames?: boolean;
}

export const RowButtons = React.memo(({disabled = false, className, showNames = true, buttons}: Props) => (
    <div className={className}>
        {buttons.map((button) => (
            <Button
                key={button.name}
                theme={"clear"}
                size={"s"}
                view={"default"}
                tone={"default"}
                onClick={button.handler}
                disabled={disabled}
                title={button.name}
                cls={classNames(classes.button, button.className)}
            >
                {button.icon ? <FontAwesomeIcon icon={button.icon} /> : null} {showNames ? button.name : null}
            </Button>
        ))}
    </div>
));

RowButtons.displayName = "RowButtons";
