import {fixedMemo} from "@yandex-infracloud-ui/libs";
import React, {FC} from "react";
import {Route, Switch} from "react-router-dom";

import {AppRouteProps} from "../../../models";
import {Error404Page} from "../../../pages/404";

interface Props {
    children: AppRouteProps[];
}

export const SwitchRoutes: FC<Props> = fixedMemo(({children}) => (
    <Switch>
        {children.map((r) => (
            <Route key={(r.path as any) || "404"} {...r} />
        ))}
        <Route component={Error404Page} />
    </Switch>
));

SwitchRoutes.displayName = "SwitchRoutes";
